<?php
    header('Access-Control-Allow-Origin: *'); 
    header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");

    include "vendor/autoload.php";

    use Stenfrank\UBL21dian\Client;
    use Stenfrank\UBL21dian\ClientProd;
    use Stenfrank\UBL21dian\Templates\SOAP\SendBillSync;
    use Stenfrank\UBL21dian\Templates\SOAP\SendBillSyncProd;
    use Stenfrank\UBL21dian\Templates\SOAP\SendEventUpdateStatus;

    $json = json_decode($_POST['data'],true);

    $zip = new ZipArchive();
    
    $filename = 'D:/ERP/Apache24/DATA/'.substr($json['codigoempresa'],0,5).'/TEMPORALES/'.$json['ARCHIVO'].'.zip';
    $zip->open($filename,ZIPARCHIVE::CREATE);
    $zip->addFile('D:/ERP/Apache24/DATA/'.substr($json['codigoempresa'],0,5).'/TEMPORALES/'.$json['ARCHIVO'].'.xml',$json['ARCHIVO'].'.xml');
    $zip->close();

    $certificado = $json['FIRMADIGIT'];
    $password = $json['SERIECERTI'];

    $base = file_get_contents('D:/ERP/Apache24/DATA/'.substr($json['codigoempresa'],0,5).'/TEMPORALES/'.$json['ARCHIVO'].'.zip');
    $codificado = base64_encode($base);

    if(substr($json['ARCHIVO'],0,4)=='acus'){
        $sendbill = new SendEventUpdateStatus($certificado,$password);
    } else {
        if($json['AMBIENTE']==0){
            $sendbill = new SendBillSync($certificado,$password);
            $sendbill->fileName = $json['ARCHIVO'].'.zip';
        } else {
            $sendbill = new SendBillSyncProd($certificado,$password);
            $sendbill->fileName = $json['ARCHIVO'].'.zip';
        }
    }

    $sendbill->contentFile = $codificado;
    $sendbill->sign();
    if($json['AMBIENTE']==0){
        $client = new Client($sendbill);
    } else {
        $client = new ClientProd($sendbill);
    }

    echo $client;
?>