<?php
    header('Access-Control-Allow-Origin: *'); 
    header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");

    date_default_timezone_set("America/Bogota");

    $finalxml = <<<XML
    <?xml version="1.0" encoding="utf-8" standalone="no"?>
    <ApplicationResponse 
        xsi:schemaLocation="urn:oasis:names:specification:ubl:schema:xsd:ApplicationResponse-2 http://docs.oasis-open.org/ubl/os-UBL-2.1/xsd/maindoc/UBL-ApplicationResponse-2.1.xsd"
        xmlns="urn:oasis:names:specification:ubl:schema:xsd:ApplicationResponse-2" 
        xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" 
        xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" 
        xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
        xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" 
        xmlns:sts="urn:dian:gov:co:facturaelectronica:Structures-2-1" 
        xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
        xmlns:xades="http://uri.etsi.org/01903/v1.3.2#" 
        xmlns:xades141="http://uri.etsi.org/01903/v1.4.1#">
        <ext:UBLExtensions>
            <ext:UBLExtension>
                <ext:ExtensionContent>
                    <sts:DianExtensions>
                        <sts:InvoiceSource>
                            <cbc:IdentificationCode listAgencyID="6" listAgencyName="United Nations Economic Commission for Europe" listSchemeURI="urn:oasis:names:specification:ubl:codelist:gc:CountryIdentificationCode-2.1">CO</cbc:IdentificationCode>
                        </sts:InvoiceSource>
                        <sts:SoftwareProvider>
                            <sts:ProviderID schemeName="31" schemeID="1" schemeAgencyName="CO, DIAN (Dirección de Impuestos y Aduanas Nacionales)" schemeAgencyID="195">901034990</sts:ProviderID>
                            <sts:SoftwareID schemeAgencyID="195" schemeAgencyName="CO, DIAN (Dirección de Impuestos y Aduanas Nacionales)">d0e0b3c7-044f-4ba0-b8a5-5470441f335d</sts:SoftwareID>
                        </sts:SoftwareProvider>
                        <sts:SoftwareSecurityCode schemeAgencyName="CO, DIAN (Dirección de Impuestos y Aduanas Nacionales)" schemeAgencyID="195">6572675e5669fa216f0f3067bdf1382702eb539e188231d4563383799fbeb9cca1a89d7e46ca55d438b5b35d4a6d5d38</sts:SoftwareSecurityCode>
                        <sts:AuthorizationProvider>
                            <sts:AuthorizationProviderID schemeID="4" schemeName="31" schemeAgencyID="195" schemeAgencyName="CO, DIAN (Dirección de Impuestos y Aduanas Nacionales)">800197268</sts:AuthorizationProviderID>
                        </sts:AuthorizationProvider>
                        <sts:QRCode>https://catalogo-vpfe.dian.gov.co/document/searchqr?documentkey=fa75189e97c04afbf99367d0e722d77d6a0cc1c54a26b1dfcd6ed445fdc89670406485e24a6ffeb15ea96f4e29792b06</sts:QRCode> 
                    </sts:DianExtensions>
                </ext:ExtensionContent>
            </ext:UBLExtension>
            <ext:UBLExtension>
                <ext:ExtensionContent>
                </ext:ExtensionContent>
            </ext:UBLExtension>
        </ext:UBLExtensions>
        <cbc:UBLVersionID>UBL 2.1</cbc:UBLVersionID>
        <cbc:CustomizationID>1</cbc:CustomizationID>
        <cbc:ProfileID>DIAN 2.1: ApplicationResponse de la Factura Electrónica de Venta</cbc:ProfileID>
        <cbc:ProfileExecutionID>2</cbc:ProfileExecutionID>
        <cbc:ID>2</cbc:ID>
        <cbc:UUID schemeID="2" schemeName="CUDE-SHA384"></cbc:UUID>
        <cbc:IssueDate>2022-02-16</cbc:IssueDate>
        <cbc:IssueTime>20:33:14-05:00</cbc:IssueTime>
        <cbc:Note>Pruebas del Acuse de recibo</cbc:Note>
        <cac:SenderParty>
            <cac:PartyTaxScheme>
                <cbc:RegistrationName>VISUALSOFT COLOMBIA SAS</cbc:RegistrationName>
                <cbc:CompanyID schemeAgencyID="195" schemeAgencyName="CO, DIAN (Dirección de Impuestos y Aduanas Nacionales)" schemeID="1" schemeName="31" schemeVersionID="1">901034990</cbc:CompanyID>
                <cac:TaxScheme>
                    <cbc:ID>01</cbc:ID>
                    <cbc:Name>IVA</cbc:Name>
                </cac:TaxScheme>
            </cac:PartyTaxScheme>
        </cac:SenderParty>
        <cac:ReceiverParty>
            <cac:PartyTaxScheme>
                <cbc:RegistrationName>INVERSIONES AMANCAY SAS</cbc:RegistrationName>
                <cbc:CompanyID schemeAgencyID="195" schemeAgencyName="CO, DIAN (Dirección de Impuestos y Aduanas Nacionales)" schemeID="3" schemeName="31" schemeVersionID="1">901440207</cbc:CompanyID>
                <cac:TaxScheme>
                    <cbc:ID>01</cbc:ID>
                    <cbc:Name>IVA</cbc:Name>
                </cac:TaxScheme>
            </cac:PartyTaxScheme>
        </cac:ReceiverParty>
        <cac:DocumentResponse>
            <cac:Response>
                <cbc:ResponseCode name="">030</cbc:ResponseCode>
                <cbc:Description>Acuse de recibo de Factura Electrónica de Venta</cbc:Description>
            </cac:Response>
            <cac:DocumentReference>
                <cbc:ID>SETT25</cbc:ID>
                <cbc:UUID schemeName="CUFE-SHA384">fa75189e97c04afbf99367d0e722d77d6a0cc1c54a26b1dfcd6ed445fdc89670406485e24a6ffeb15ea96f4e29792b06</cbc:UUID>
                <cbc:DocumentTypeCode>01</cbc:DocumentTypeCode>
            </cac:DocumentReference>
            <cac:IssuerParty>
                <cac:Person>
                    <cbc:ID schemeID=" " schemeName="13">375064</cbc:ID>
                    <cbc:FirstName>RENE</cbc:FirstName>
                    <cbc:FamilyName>JARA</cbc:FamilyName>
                    <cbc:JobTitle>Representante Legal</cbc:JobTitle>
                    <cbc:OrganizationDepartment>Gerencia Administrativa</cbc:OrganizationDepartment>
                </cac:Person>
            </cac:IssuerParty>
        </cac:DocumentResponse>
    </ApplicationResponse>
    XML;

    //file_put_contents('D:/PYTHON/ERP/DATA/'.$json['codigoempresa'].'/TEMPORALES/acuse_recibido_'.$json['NITSDEMP'].'_'.strtolower($json['prefijo']).'_'.str_pad($json['folio'],9,'0',STR_PAD_LEFT).'.xml',$finalxml);
    
    file_put_contents('D:/PYTHON/ERP/DATA/HA001/TEMPORALES/acuse_recibido_prueba.xml',$finalxml);

    echo json_encode('XML Creado');
?>